<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\User;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityTherapists\CreateRequest;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityTherapists\UpdateRequest;
use App\Http\Resources\Web\TherapistsResource;
use App\Notifications\Auth\TherapistCredentialsNotification;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;

class TherapistCommunityTherapistsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');

      // $this->middleware('permission:therapist_community_therapists.index');
      // $this->middleware('permission:therapist_community_therapists.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_therapists.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_therapists.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_therapists.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_therapists.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_therapists.update|therapist_community_therapists.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_therapists =  $therapist_community->therapist_community_therapists()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_therapists =  $therapist_community_therapists->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_therapists =  $therapist_community_therapists->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_therapists = $therapist_community_therapists->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_therapists = $therapist_community_therapists->whereLike(['first_name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_therapists = $therapist_community_therapists->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_therapists = $therapist_community_therapists->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_therapists = $therapist_community_therapists->get();
        return $therapist_community_therapists;
      }
      $totalTherapistCommunityTherapists = $therapist_community_therapists->count();
      $therapist_community_therapists = $therapist_community_therapists->paginate($req->perPage);
      $therapist_community_therapists = TherapistsResource::collection($therapist_community_therapists)->response()->getData(true);

      return $therapist_community_therapists;
    }
    $therapist_community_therapists = TherapistsResource::collection($therapist_community->therapist_community_therapists()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_therapists;
  }

  /********* FETCH ALL TherapistCommunityTherapists ***********/
    public function index()
    {
        $therapist_community_therapists =  $this->getter();
        $response = generateResponse($therapist_community_therapists,count($therapist_community_therapists['data']) > 0 ? true:false,'TherapistCommunity Therapists Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityTherapists FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_therapists = $this->getter($request);
     $response = generateResponse($therapist_community_therapists,count($therapist_community_therapists['data']) > 0 ? true:false,'Filter TherapistCommunity Therapists Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityTherapist ***********/
    public function store(CreateRequest $request)
    {
      $therapist_community = auth()->user()->therapist_community;
      try{
    //   DB::beginTransaction();
      $data = $request->all();
        $data['name'] = $data['first_name'] . ' ' . $data['last_name'];
        $data['password'] = Hash::make($request->password);
        $data['email'] = $request->email;
        $user = User::create($data);

        $user->roles()->attach(['therapist']);
        $pricing_plan = getTherapistDefaultPricingPlan();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_therapists');
        }

        $therapist = $user->therapist()->create([
            'pricing_plan_id' => $pricing_plan->id ?? null,
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'is_active' => $request['is_active'],
            'experience' => $request['experience'],
            'speciality' => $request['speciality'],
            'therapist_community_id' => $therapist_community->id,
            'user_name' => $request->user_name,
            'image' =>$data['image'] ?? null,
            'zip_code' => $data['zip_code'] ?? null
        ]);
        $therapist->therapist_categories()->attach($request->therapist_categories);
        $user->sendEmailVerificationNotification();
        $user->notify(new TherapistCredentialsNotification($user,$request->password));
      $therapist_community_therapist = $therapist_community->therapist_community_therapists()->withAll()->find($therapist_community->id);
      $therapist_community_therapist = new TherapistsResource($therapist_community_therapist);
    //   DB::commit();
    }
      catch (\Exception $e) {
        // DB::rollBack();
        // request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_therapist)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_therapist->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_therapist = $therapist_community->therapist_community_therapists()->withAll()->find($therapist_community_therapist);
        if($therapist_community_therapist){
          $therapist_community_therapist = new TherapistsResource($therapist_community_therapist);
          $response = generateResponse($therapist_community_therapist,true,'TherapistCommunity Therapist Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunity Therapist Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunity Therapist ***********/
    public function update(UpdateRequest $request, Therapist $therapist_community_therapist)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_therapist->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_therapists',$therapist_community_therapist->image);
        } else {
            $data['image'] = $therapist_community_therapist->image;
        }
        $therapist_community_therapist->update($data);
        $therapist_community_therapist->therapist_categories()->sync($request->therapist_categories);

        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunity Therapist Status***********/
    public function updateStatus(Request $request, Therapist $therapist_community_therapist){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_therapist->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_therapist->update([
          'is_active' => $therapist_community_therapist->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunity Therapist Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunity Therapist ***********/
    public function destroy(Request $request,Therapist $therapist_community_therapist)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_therapist->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_therapist->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            // dd($therapist_community_therapist->therapist_categories());
            User::find($therapist_community_therapist->user_id)->delete();

            $therapist_community_therapist->therapist_categories()->sync([]);
            $therapist_community_therapist->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunity Therapist ***********/
    public function destroyPermanently(Request $request,$therapist_community_therapist)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_therapist = $therapist_community->therapist_community_therapists()->withTrashed()->find($therapist_community_therapist);
        if($therapist_community_therapist){
            if($therapist_community_therapist->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_therapist->trashed()) {
            $therapist_community_therapist->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunity Therapist Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunity Therapist is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunity Therapist not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunity Therapist ***********/
    public function restore(Request $request,$therapist_community_therapist)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_therapist = $therapist_community->therapist_community_therapists()->withTrashed()->find($therapist_community_therapist);
          if ($therapist_community_therapist->trashed()) {
            $therapist_community_therapist->restore();
            $response = generateResponse(null,true,'TherapistCommunity Therapist Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunity Therapist is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
